//=============================================================================
// Box Gun4
//=============================================================================
class MSBoxGun extends DeusExWeapon;

var SmallBox small; 
var MedBox med; 
var LargeBox big; 
var travel byte BoxMode;
var travel bool bRotAdjust;
var travel Texture CurSkin;
var travel byte SkinMode;

#exec Texture Import File=C:\DeusEx\MSBoxGun4\Textures\MSBoxTex2.pcx Name=MSBoxTex2 GROUP="Skins"
#exec Texture Import File=C:\DeusEx\MSBoxGun4\Textures\MSBoxTex3.pcx Name=MSBoxTex3 GROUP="Skins"
#exec Texture Import File=C:\DeusEx\MSBoxGun4\Textures\MSBoxTex4.pcx Name=MSBoxTex4 GROUP="Skins"
#exec Texture Import File=C:\DeusEx\MSBoxGun4\Textures\MSBoxTex5.pcx Name=MSBoxTex5 GROUP="Skins"
#exec Texture Import File=C:\DeusEx\MSBoxGun4\Textures\MSBoxTex6.pcx Name=MSBoxTex6 GROUP="Skins"
#exec Texture Import File=C:\DeusEx\MSBoxGun4\Textures\MSBoxTex7.pcx Name=MSBoxTex7 GROUP="Skins"
#exec Texture Import File=C:\DeusEx\MSBoxGun4\Textures\MSBoxTex8.pcx Name=MSBoxTex8 GROUP="Skins"
#exec Texture Import File=C:\DeusEx\MSBoxGun4\Textures\CompanionCube2.pcx Name=CompanionCube2 GROUP="Skins"

state NormalFire
{
Begin:
	if ((ClipCount >= ReloadCount) && (ReloadCount != 0))
	{
		if (!bAutomatic)
		{
			bFiring = False;
			FinishAnim();
		}

		if (Owner != None)
		{
			if (Owner.IsA('DeusExPlayer'))
			{
				bFiring = False;


				// should we autoreload?
				if (DeusExPlayer(Owner).bAutoReload)
				{
					// auto switch ammo if we're out of ammo and
					// we're not using the primary ammo
					if ((AmmoType.AmmoAmount == 0) && (AmmoName != AmmoNames[0]))
						CycleAmmo();
					ReloadAmmo();
				}
				else
				{
					if (bHasMuzzleFlash)
						EraseMuzzleFlashTexture();
					GotoState('Idle');
				}
			}
			else if (Owner.IsA('ScriptedPawn'))
			{
				bFiring = False;
				ReloadAmmo();
			}
		}
		else
		{
			if (bHasMuzzleFlash)
				EraseMuzzleFlashTexture();
			GotoState('Idle');
		}
	}
	if ( bAutomatic && (( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient())))
		GotoState('Idle');

	Sleep(GetShotTime());
	if (bAutomatic)
	{
		GenerateBullet();	// In multiplayer bullets are generated by the client which will let the server know when
		Goto('Begin');
	}
	bFiring = False;
	FinishAnim();

	ReadyToFire();
Done:
	bFiring = False;
	Finish();
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
local SmallBox small; 
local MedBox med; 
local LargeBox big; 
local DeusExPlayer P;
P = DeusExPlayer(Owner);
if (P != None)    
{ 
 if (BoxMode == 0)
 {
  if (bRotAdjust)
  {
  small = spawn(class'SmallBox',,,HitLocation,P.Rotation);
  }
  if (!bRotAdjust)
  {
  small = spawn(class'SmallBox',,,HitLocation,Default.Rotation);
  }
 }
 if (BoxMode == 1)
 {
  if (bRotAdjust)
  {
  med = spawn(class'MedBox',,,HitLocation,P.Rotation);
  }
  if (!bRotAdjust)
  {
  med = spawn(class'MedBox',,,HitLocation,Default.Rotation);
  }
 }
 if (BoxMode == 2)
 {
  if (bRotAdjust)
  {
  big = spawn(class'LargeBox',,,HitLocation,P.Rotation);
  }
  if (!bRotAdjust)
  {
  big = spawn(class'LargeBox',,,HitLocation,Default.Rotation);
  }
 }
 if (BoxMode == 3)
 {
  if ((Other != None) && Other.IsA('SmallBox') || Other.IsA('MedBox') || Other.IsA('LargeBox'))
  {
  Other.Destroy();
  }
 }
 if (BoxMode == 4)
 {
  if ((Other != None) && Other.IsA('Decoration') || Other.IsA('Pawn'))
  {
      if(P.bAdmin)
      {
          if (bRotAdjust)
          {
          Other.Mesh = LodMesh'DeusExDeco.CrateUnbreakableSmall';
          Other.MultiSkins[0] = P.MultiSkins[0];
          Other.DrawScale = 1;
          }
          if (!bRotAdjust)
          {
          Other.Mesh = LodMesh'DeusExDeco.CrateUnbreakableSmall';
          Other.DrawScale = 1;
          }
      }
  }
 }
 if (BoxMode == 5)
 {
    if(P.bAdmin)
    {
    ForEach AllActors(class'SmallBox',small)
    {
    if (small != None)  
      {
          small.Destroy();
      }
    }
    ForEach AllActors(class'MedBox',med)
    {    
    if (med != None) 
      {
          med.Destroy();
      }
    }
    ForEach AllActors(class'LargeBox',big)
    {    
    if (big != None) 
      {
          big.Destroy();
      }
    }
    }
 }
 if (BoxMode == 6)
 {
  if ((Other != None) && Other.IsA('SmallBox') || Other.IsA('MedBox') || Other.IsA('LargeBox'))
  {
      if ((Other.DrawScale < Other.Default.DrawScale*2) && (Other.DrawScale >= Other.Default.DrawScale*1))
      {
      Other.DrawScale += Other.Default.DrawScale/2;
      Other.SetCollisionSize(Other.CollisionRadius+Other.Default.CollisionRadius/2,Other.CollisionHeight+Other.Default.CollisionHeight/2);
      }
      if (Other.DrawScale < Other.Default.DrawScale*1)
      {
      Other.DrawScale += Other.Default.DrawScale/5;
      Other.SetCollisionSize(Other.CollisionRadius+Other.Default.CollisionRadius/5,Other.CollisionHeight+Other.Default.CollisionHeight/5);
      }
  }
 }
 if (BoxMode == 7)
 {
  if ((Other != None) && Other.IsA('SmallBox') || Other.IsA('MedBox') || Other.IsA('LargeBox'))
  {
      if ((Other.DrawScale > Other.Default.DrawScale/5*2) && (Other.DrawScale <= Other.Default.DrawScale*1))
      {
      Other.DrawScale -= Other.Default.DrawScale/5;
      Other.SetCollisionSize(Other.CollisionRadius-Other.Default.CollisionRadius/5,Other.CollisionHeight-Other.Default.CollisionHeight/5);
      }
      if (Other.DrawScale > Other.Default.DrawScale*1)
      {
      Other.DrawScale -= Other.Default.DrawScale/2;
      Other.SetCollisionSize(Other.CollisionRadius-Other.Default.CollisionRadius/2,Other.CollisionHeight-Other.Default.CollisionHeight/2);
      }
  }
 }
 if (BoxMode == 8)
 {
  if ((Other != None) && Other.IsA('SmallBox') || Other.IsA('MedBox') || Other.IsA('LargeBox'))
  {
   if (Other.MultiSkins[0] != CurSkin)
   {
     Other.Multiskins[0] = CurSkin;

     if (SkinMode == 7)
     {
       Other.Style = STY_Translucent;
     }
     Else
     {
       Other.Style = STY_Normal;
     }
   }
  }
 }
}
}

Function CycleAmmo()
{
    local DeusExplayer P;
    P=DeusExPlayer(Owner);
        
    if (BoxMode == 0)
    {
        BoxMode = 1;
	DeusExPlayer(Owner).Clientmessage("|P4Mode set to medium boxes.");
        return;
    }
    if (BoxMode == 1)
    {
        BoxMode = 2;
	DeusExPlayer(Owner).Clientmessage("|P4Mode set to Large boxes.");
        return;
    }
    if (BoxMode == 2)
    {
        BoxMode = 3;
	DeusExPlayer(Owner).Clientmessage("|cf88Mode set to Delete boxes.");
        return;
    }
    if (BoxMode == 3)
    {
      if(P.bAdmin)
      {
        BoxMode = 4;
	DeusExPlayer(Owner).Clientmessage("|ca128fMode set to box mutator.");
        return;
      }
      else
      {
        BoxMode = 6;
	DeusExPlayer(Owner).Clientmessage("|P4Mode set to increase box size.");
        return;
      }
    }
    if (BoxMode == 4)
    {
      if(P.bAdmin)
      {
        BoxMode = 5;
	DeusExPlayer(Owner).Clientmessage("|P2Mode set to erase all boxes.");
        return;
      }
      else
      {
        BoxMode = 6;
	DeusExPlayer(Owner).Clientmessage("|P4Mode set to increase box size.");
        return;
      }
    }
    if (BoxMode == 5)
    {
        BoxMode = 6;
	DeusExPlayer(Owner).Clientmessage("|P4Mode set to increase box size.");
        return;
    }
    if (BoxMode == 6)
    {
        BoxMode = 7;
	DeusExPlayer(Owner).Clientmessage("|P4Mode set to decrease box size.");
        return;
    }
    if (BoxMode == 7)
    {
        BoxMode = 8;
	DeusExPlayer(Owner).Clientmessage("|P3Mode set to change box skin, Use your scope button to change the skin you are setting the cube to!");
        return;
    }
    if (BoxMode == 8)
    {
        BoxMode = 0;
	DeusExPlayer(Owner).Clientmessage("|P4Mode set to small boxes.");
        return;
    }
}

Function LaserToggle()
{
    local DeusExplayer P;
    P=DeusExPlayer(Owner);
        
    if (!bRotAdjust)
    {
        bRotAdjust = True;
	DeusExPlayer(Owner).Clientmessage("|P7Boxes set to adjust to player rotation.");
        return;
    }
    if (bRotAdjust)
    {
        bRotAdjust = False;
	DeusExPlayer(Owner).Clientmessage("|P7Boxes set to adjust to default rotation.");
        return;
    }
}

Function ScopeToggle()
{
    local DeusExplayer P;
    P=DeusExPlayer(Owner);
        
    if (SkinMode == 0)
    {
        SkinMode = 1;
        CurSkin = Texture'MSBoxGun4.MSBoxTex2';
	DeusExPlayer(Owner).Clientmessage("|P3Skin set to red bricks.");
        return;
    }
    if (SkinMode == 1)
    {
        SkinMode = 2;
        CurSkin = Texture'MSBoxGun4.MSBoxTex3';
	DeusExPlayer(Owner).Clientmessage("|P3Skin set to gray bricks.");
        return;
    }
    if (SkinMode == 2)
    {
        SkinMode = 3;
        CurSkin = Texture'MSBoxGun4.MSBoxTex4';
	DeusExPlayer(Owner).Clientmessage("|P3Skin set to sand bricks.");
        return;
    }
    if (SkinMode == 3)
    {
        SkinMode = 4;
        CurSkin = Texture'MSBoxGun4.MSBoxTex5';
	DeusExPlayer(Owner).Clientmessage("|P3Skin set to Green Paint.");
        return;
    }
    if (SkinMode == 4)
    {
        SkinMode = 5;
        CurSkin = Texture'MSBoxGun4.MSBoxTex6';
	DeusExPlayer(Owner).Clientmessage("|P3Skin set to Blue Paint.");
        return;
    }
    if (SkinMode == 5)
    {
        SkinMode = 6;
        CurSkin = Texture'MSBoxGun4.MSBoxTex7';
	DeusExPlayer(Owner).Clientmessage("|P3Skin set to Red Paint.");
        return;
    }
    if (SkinMode == 6)
    {
        SkinMode = 7;
        CurSkin = Texture'MSBoxGun4.MSBoxTex8';
	DeusExPlayer(Owner).Clientmessage("|P3Skin set to Window.");
        return;
    }
    if (SkinMode == 7)
    {
        SkinMode = 8;
        CurSkin = Texture'MSBoxGun4.CompanionCube2';
	DeusExPlayer(Owner).Clientmessage("|P3Skin set to companion cube, LOL.");
        return;
    }
    if (SkinMode == 8)
    {
        SkinMode = 0;
        CurSkin = Texture'MSBoxGun4.CrateUnbreakableSmallTex1';
	DeusExPlayer(Owner).Clientmessage("|P3Skin set to normal.");
        return;
    }
}

defaultproperties
{
     LowAmmoWaterMark=4
     GoverningSkill=Class'DeusEx.SkillWeaponHeavy'
     NoiseLevel=0.000000
     reloadTime=0.000001
     HitDamage=300
     maxRange=24000
     AccurateRange=14400
     BaseAccuracy=0.000000
     bCanHaveScope=True
     bHasScope=True
     bHasMuzzleFlash=False
     recoilStrength=1.000000
     bEmitWeaponDrawn=False
     bUseWhileCrouched=False
     mpHitDamage=40
     mpAccurateRange=14400
     mpMaxRange=14400
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     PickupAmmoCount=10
     bInstantHit=True
     bWeaponStay=True
     FireOffset=(X=-46.000000,Y=22.000000,Z=10.000000)
     shakemag=0.000000
     FireSound=Sound'DeusExSounds.Weapons.LAWFire'
     SelectSound=Sound'DeusExSounds.Weapons.LAWSelect'
     InventoryGroup=252
     PickupMessage="|p4Use your change ammo button to switch between modes and your laser toggle button, |p3] |p4by default, to change rotation settings. |p1You have obtained"
     ItemName="|p1Markistan Corp Box Gun"
     ItemArticle="|p1a"
     PlayerViewOffset=(X=18.000000,Y=-18.000000,Z=-7.000000)
     PlayerViewMesh=LodMesh'DeusExItems.LAW'
     PickupViewMesh=LodMesh'DeusExItems.LAWPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.LAW3rd'
     LandSound=Sound'DeusExSounds.Generic.DropLargeWeapon'
     Icon=Texture'DeusExUI.Icons.BeltIconLAW'
     largeIcon=Texture'DeusExUI.Icons.LargeIconLAW'
     largeIconWidth=166
     largeIconHeight=47
     invSlotsX=4
     Description="BOXES!!!"
     beltDescription="BOX GUN"
     Mesh=LodMesh'DeusExItems.LAWPickup'
     CollisionRadius=27.000000
     CollisionHeight=6.600000
     Mass=30.000000
     CurSkin=Texture'DeusExDeco.CrateUnbreakableSmallTex1'
}
